function F=FindBestRigidTransformation(A,B,method)
% Find F = Argmin (F*A-B)^2
%
% method may be 'Arun' or 'Horn'  Current default is 'Arun'
%  
% 
% Copyright (C) Russell H. Taylor 2013
% For use with CIS I only
% Do not redistribute without written permission from Russell Taylor

    if nargin>2
        m = method;
    else
        m = 'Arun'; % Horn's method seems to be having troubles with MSTLAB eigs routine
    end
    switch class(A)
        case 'Frame'
            AA=[]; BB=[]; 
            for i=1:size(A,1)
                for j=1:size(A,2)
                    AA=[AA,A(i,j).R.el];
                    BB=[BB,B(i,j).R.el];
                end
            end
            R = FindBestRigidRotation(vct3Array(AA),vct3Array(BB),m);
            n=0;T=vct3(0,0,0);
            for i=1:size(A,1)
                for j=1:size(A,2)
                    T=T+B(i,j).p-R*A(i,j).p;
                    n=n+1;
                end
            end
            F = Frame(R,T*(1/n));
        case 'vct3Array'
            Amean = A.mean();
            Bmean = B.mean();

            R = FindBestRigidRotation(A-Amean,B-Bmean,m);
            F = Frame(R,Bmean-R*Amean);
        otherwise
            error('BadParam','Bad Parameter to FindBestRigidTransformation',A);
    end
end

